# src/routes/access_keys.py
from flask import Blueprint, request, jsonify
from flask_cors import cross_origin
from src.models.database import db
from src.models import AccessKey
from datetime import datetime, timedelta

access_keys_bp = Blueprint('access_keys', __name__, url_prefix='/api/access-keys')

# جلب جميع مفاتيح الوصول
# جلب جميع مفاتيح الوصول
@access_keys_bp.route('/', methods=['GET'], strict_slashes=False)
@cross_origin()
def get_access_keys():
    keys = AccessKey.query.all()
    result = [
        {
            'id': key.id,
            'key_value': key.key_value,
            'user_id': key.user_id,
            'expires_at': key.expires_at.isoformat() if key.expires_at else None,
            'is_active': key.is_active
        }
        for key in keys
    ]
    return jsonify(result), 200

# إنشاء مفتاح وصول جديد
@access_keys_bp.route('/', methods=['POST'], strict_slashes=False)
@cross_origin()
def create_access_key():
    data = request.get_json()
    key_value = data.get('key_value')
    user_id = data.get('user_id')
    is_active = data.get('is_active', True)
    expires_in_days = data.get('expires_in_days')

    if not key_value:
        return jsonify({'error': 'Key value is required'}), 400
    if not user_id:
        return jsonify({'error': 'User ID is required'}), 400

    expires_at = None
    if expires_in_days:
        try:
            expires_at = datetime.utcnow() + timedelta(days=int(expires_in_days))
        except ValueError:
            return jsonify({'error': 'Invalid expires_in_days value'}), 400

    new_key = AccessKey(
        key_value=key_value,
        user_id=user_id,
        expires_at=expires_at,
        is_active=is_active
    )
    db.session.add(new_key)
    db.session.commit()

    return jsonify({
        'id': new_key.id,
        'key_value': new_key.key_value,
        'user_id': new_key.user_id,
        'expires_at': new_key.expires_at.isoformat() if new_key.expires_at else None,
        'is_active': new_key.is_active
    }), 201
