from flask_sqlalchemy import SQLAlchemy
from datetime import datetime
import uuid

db = SQLAlchemy()

class Opportunity(db.Model):
    __tablename__ = 'opportunities'
    
    id = db.Column(db.String(36), primary_key=True, default=lambda: str(uuid.uuid4()))
    pair_name = db.Column(db.String(20), nullable=False)
    direction = db.Column(db.String(10), nullable=False)  # 'up' or 'down'
    time_frame = db.Column(db.String(20), nullable=False)
    marginal = db.Column(db.Float, nullable=False)
    reason = db.Column(db.Text, nullable=False)
    confidence = db.Column(db.Integer, nullable=False)  # 0-100
    risk_level = db.Column(db.String(20), nullable=False)  # 'منخفض', 'متوسط', 'عالي'
    entry_time = db.Column(db.DateTime, nullable=False)
    is_live = db.Column(db.Boolean, default=True, nullable=False)
    created_at = db.Column(db.DateTime, default=datetime.utcnow, nullable=False)
    created_by = db.Column(db.String(36), nullable=True)  # Admin who created it
    
    def __repr__(self):
        return f'<Opportunity {self.pair_name} {self.direction}>'
    
    def is_active(self):
        """Check if the opportunity is still active"""
        return self.is_live and self.entry_time > datetime.utcnow()
    
    def to_dict(self):
        return {
            'id': self.id,
            'pair_name': self.pair_name,
            'direction': self.direction,
            'time_frame': self.time_frame,
            'marginal': self.marginal,
            'reason': self.reason,
            'confidence': self.confidence,
            'risk_level': self.risk_level,
            'entry_time': self.entry_time.isoformat(),
            'is_live': self.is_live,
            'created_at': self.created_at.isoformat(),
            'created_by': self.created_by
        }

