from flask_sqlalchemy import SQLAlchemy
from datetime import datetime
import uuid

db = SQLAlchemy()

class HistoryLog(db.Model):
    __tablename__ = 'history_logs'
    
    id = db.Column(db.String(36), primary_key=True, default=lambda: str(uuid.uuid4()))
    opportunity_id = db.Column(db.String(36), db.ForeignKey('opportunities.id'), nullable=True)
    pair_name = db.Column(db.String(20), nullable=False)
    direction = db.Column(db.String(10), nullable=False)
    entry_price = db.Column(db.Float, nullable=False)
    exit_price = db.Column(db.Float, nullable=False)
    result = db.Column(db.String(10), nullable=False)  # 'win', 'loss', 'draw'
    profit_loss = db.Column(db.Float, nullable=False)  # in pips/points
    time_frame = db.Column(db.String(20), nullable=False)
    confidence = db.Column(db.Integer, nullable=False)
    reason = db.Column(db.Text, nullable=False)
    logged_at = db.Column(db.DateTime, default=datetime.utcnow, nullable=False)
    trade_date = db.Column(db.Date, nullable=False)
    trade_time = db.Column(db.Time, nullable=False)
    
    # Relationship
    opportunity = db.relationship('Opportunity', backref='history_logs')
    
    def __repr__(self):
        return f'<HistoryLog {self.pair_name} {self.result}>'
    
    def to_dict(self):
        return {
            'id': self.id,
            'opportunity_id': self.opportunity_id,
            'pair_name': self.pair_name,
            'direction': self.direction,
            'entry_price': self.entry_price,
            'exit_price': self.exit_price,
            'result': self.result,
            'profit_loss': self.profit_loss,
            'time_frame': self.time_frame,
            'confidence': self.confidence,
            'reason': self.reason,
            'logged_at': self.logged_at.isoformat(),
            'trade_date': self.trade_date.isoformat(),
            'trade_time': self.trade_time.isoformat()
        }

