from flask_sqlalchemy import SQLAlchemy
from datetime import datetime
import uuid

db = SQLAlchemy()

class Content(db.Model):
    __tablename__ = 'content'
    
    id = db.Column(db.String(36), primary_key=True, default=lambda: str(uuid.uuid4()))
    type = db.Column(db.String(50), nullable=False)  # 'education', 'guidelines', 'faq'
    category = db.Column(db.String(100), nullable=True)
    title = db.Column(db.String(255), nullable=False)
    body = db.Column(db.Text, nullable=False)
    summary = db.Column(db.Text, nullable=True)
    difficulty = db.Column(db.String(20), nullable=True)  # 'مبتدئ', 'متوسط', 'متقدم'
    read_time = db.Column(db.String(20), nullable=True)  # '10 دقائق'
    is_published = db.Column(db.Boolean, default=True, nullable=False)
    created_at = db.Column(db.DateTime, default=datetime.utcnow, nullable=False)
    updated_at = db.Column(db.DateTime, default=datetime.utcnow, onupdate=datetime.utcnow, nullable=False)
    created_by = db.Column(db.String(36), nullable=True)  # Admin who created it
    
    def __repr__(self):
        return f'<Content {self.title}>'
    
    def to_dict(self):
        return {
            'id': self.id,
            'type': self.type,
            'category': self.category,
            'title': self.title,
            'body': self.body,
            'summary': self.summary,
            'difficulty': self.difficulty,
            'read_time': self.read_time,
            'is_published': self.is_published,
            'created_at': self.created_at.isoformat(),
            'updated_at': self.updated_at.isoformat(),
            'created_by': self.created_by
        }

