from flask_sqlalchemy import SQLAlchemy
from datetime import datetime
import uuid

db = SQLAlchemy()

class ChartAnalysis(db.Model):
    __tablename__ = 'chart_analyses'
    
    id = db.Column(db.String(36), primary_key=True, default=lambda: str(uuid.uuid4()))
    user_id = db.Column(db.String(36), db.ForeignKey('users.id'), nullable=True)
    image_filename = db.Column(db.String(255), nullable=False)
    image_path = db.Column(db.String(500), nullable=False)
    result_direction = db.Column(db.String(10), nullable=False)  # 'up' or 'down'
    confidence = db.Column(db.Integer, nullable=False)  # 0-100
    time_frame = db.Column(db.String(20), nullable=False)
    marginal = db.Column(db.Float, nullable=False)
    reasons = db.Column(db.Text, nullable=False)  # JSON string of reasons
    risk_level = db.Column(db.String(20), nullable=False)
    entry_price = db.Column(db.String(20), nullable=True)
    target_price = db.Column(db.String(20), nullable=True)
    created_at = db.Column(db.DateTime, default=datetime.utcnow, nullable=False)
    
    # Relationship
    user = db.relationship('User', backref='chart_analyses')
    
    def __repr__(self):
        return f'<ChartAnalysis {self.result_direction} {self.confidence}%>'
    
    def to_dict(self):
        import json
        return {
            'id': self.id,
            'user_id': self.user_id,
            'image_filename': self.image_filename,
            'result_direction': self.result_direction,
            'confidence': self.confidence,
            'time_frame': self.time_frame,
            'marginal': self.marginal,
            'reasons': json.loads(self.reasons) if self.reasons else [],
            'risk_level': self.risk_level,
            'entry_price': self.entry_price,
            'target_price': self.target_price,
            'created_at': self.created_at.isoformat()
        }

