import os
import sys
from flask import Flask, send_from_directory
from flask_cors import CORS
from dotenv import load_dotenv

# تحميل متغيرات البيئة
load_dotenv()

# DON'T CHANGE THIS !!!
sys.path.insert(0, os.path.dirname(os.path.dirname(__file__)))

# ✅ استدعاء db من database.py
from src.models.database import db  

# استدعاء الـ routes
from src.routes.tradingview import tradingview_bp
from src.routes.chart_analysis_ai import chart_ai_bp
from src.routes.user import user_bp
from src.routes.auth import auth_bp
from src.routes.opportunities import opportunities_bp
from src.routes.chart_analysis import chart_analysis_bp
from src.routes.dashboard import dashboard_bp
from src.routes.image_analysis import image_ai_bp
from src.routes.access_keys import access_keys_bp

# إنشاء تطبيق Flask
app = Flask(__name__, static_folder=os.path.join(os.path.dirname(__file__), 'static'))
app.config['SECRET_KEY'] = 'sryaino#2024$secure$key#trading'

# تمكين CORS
CORS(app)



# تسجيل Blueprints
app.register_blueprint(chart_ai_bp, url_prefix='/api/chart-ai')
app.register_blueprint(user_bp, url_prefix='/api')
app.register_blueprint(auth_bp, url_prefix='/api/auth')
app.register_blueprint(opportunities_bp, url_prefix='/api/opportunities')
app.register_blueprint(chart_analysis_bp, url_prefix='/api/chart-analysis')
app.register_blueprint(dashboard_bp, url_prefix='/api/dashboard')
app.register_blueprint(tradingview_bp, url_prefix="/api/tradingview")
app.register_blueprint(image_ai_bp, url_prefix="/api/image-ai")

app.register_blueprint(access_keys_bp, url_prefix='/api/access-keys')


# إعداد قاعدة البيانات
app.config['SQLALCHEMY_DATABASE_URI'] = f"sqlite:///{os.path.join(os.path.dirname(__file__), 'database', 'app.db')}"
app.config['SQLALCHEMY_TRACK_MODIFICATIONS'] = False
app.config['MAX_CONTENT_LENGTH'] = 16 * 1024 * 1024  # 16MB max file size

# ربط قاعدة البيانات بالتطبيق
db.init_app(app)

# استخدام app context لأي عملية على قاعدة البيانات
with app.app_context():
    # استدعاء الموديلات بعد init_app
    from src.models import User, AccessKey, Opportunity, ChartAnalysis, HistoryLog, Content

    # إنشاء الجداول
    db.create_all()

    # إضافة مفاتيح AccessKey إذا لم توجد
    from datetime import datetime, timedelta
    
    if not AccessKey.query.first():
        sample_keys = [
            AccessKey(
                key_value='SRYAINO2024TEST',
                expires_at=datetime.utcnow() + timedelta(days=30),
                is_active=True
            ),
            AccessKey(
                key_value='DEMO123456',
                expires_at=datetime.utcnow() + timedelta(days=7),
                is_active=True
            ),
            AccessKey(
                key_value='PREMIUM789',
                expires_at=None,
                is_active=True
            )
        ]
        
        db.session.add_all(sample_keys)
        db.session.commit()
        print("Sample access keys created!")

# إعداد Routes لتقديم الملفات الثابتة
@app.route('/', defaults={'path': ''})
@app.route('/<path:path>')
def serve(path):
    static_folder_path = app.static_folder
    if static_folder_path is None:
        return "Static folder not configured", 404

    if path != "" and os.path.exists(os.path.join(static_folder_path, path)):
        return send_from_directory(static_folder_path, path)
    else:
        index_path = os.path.join(static_folder_path, 'index.html')
        if os.path.exists(index_path):
            return send_from_directory(static_folder_path, 'index.html')
        else:
            return "index.html not found", 404

# Error handlers
@app.errorhandler(404)
def not_found(error):
    return send_from_directory(app.static_folder, 'index.html')

@app.errorhandler(413)
def too_large(error):
    return {'message': 'حجم الملف كبير جداً. الحد الأقصى 16MB'}, 413

# تشغيل السيرفر
if __name__ == '__main__':
    app.run(host='0.0.0.0', port=5000, debug=True)
